/*
 * Decompiled with CFR 0.152.
 */
package de.gitterrost4.adventofcode.base;

import de.gitterrost4.adventofcode.base.Direction;
import java.util.Set;
import java.util.stream.Stream;

public record Coordinate(int x, int y) {
    public Coordinate getDirection(Direction direction) {
        return this.getDirection(direction, 1);
    }

    public Coordinate getDirection(Direction direction, int amount) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> this.getNorth(amount);
            case Direction.SOUTH -> this.getSouth(amount);
            case Direction.EAST -> this.getEast(amount);
            case Direction.WEST -> this.getWest(amount);
        };
    }

    public Coordinate getEast() {
        return this.getEast(1);
    }

    public Coordinate getEast(int amount) {
        return new Coordinate(this.x, this.y + amount);
    }

    public Coordinate getWest() {
        return this.getWest(1);
    }

    public Coordinate getWest(int amount) {
        return new Coordinate(this.x, this.y - amount);
    }

    public Coordinate getNorth() {
        return this.getNorth(1);
    }

    public Coordinate getNorth(int amount) {
        return new Coordinate(this.x - amount, this.y);
    }

    public Coordinate getSouth() {
        return this.getSouth(1);
    }

    public Coordinate getSouth(int amount) {
        return new Coordinate(this.x + amount, this.y);
    }

    public Stream<Coordinate> neighbors() {
        return Stream.of(this.getNorth(), this.getWest(), this.getSouth(), this.getEast());
    }

    public String getStringRepresentation(Set<Coordinate> adjacents) {
        if (Set.of(this.getEast(), this.getWest()).equals(adjacents)) {
            return "-";
        }
        if (Set.of(this.getEast(), this.getNorth()).equals(adjacents)) {
            return "L";
        }
        if (Set.of(this.getEast(), this.getSouth()).equals(adjacents)) {
            return "F";
        }
        if (Set.of(this.getNorth(), this.getWest()).equals(adjacents)) {
            return "J";
        }
        if (Set.of(this.getSouth(), this.getWest()).equals(adjacents)) {
            return "7";
        }
        if (Set.of(this.getNorth(), this.getSouth()).equals(adjacents)) {
            return "|";
        }
        return "+";
    }

    public Coordinate normalize(int gridHeight, int gridWidth) {
        return new Coordinate((this.x % gridHeight + gridHeight) % gridHeight, (this.y % gridWidth + gridWidth) % gridWidth);
    }

    public long distance1From(Coordinate other) {
        return Math.abs(this.x - other.x) + Math.abs(this.y - other.y);
    }

    public boolean isBetween(Coordinate oneCornerInclusive, Coordinate otherCornerInclusive) {
        return (this.x <= oneCornerInclusive.x && this.x >= otherCornerInclusive.x || this.x >= oneCornerInclusive.x && this.x <= otherCornerInclusive.x) && (this.y <= oneCornerInclusive.y && this.y >= otherCornerInclusive.y || this.y >= oneCornerInclusive.y && this.y <= otherCornerInclusive.y);
    }

    @Override
    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

