/*
 * Decompiled with CFR 0.152.
 */
package de.gitterrost4.adventofcode.base;

public enum Direction {
    NORTH,
    SOUTH,
    EAST,
    WEST;


    public Direction opposite() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> SOUTH;
            case 1 -> NORTH;
            case 2 -> WEST;
            case 3 -> EAST;
        };
    }

    public static Direction fromLaymanTerms(String input) {
        return switch (input) {
            case "U" -> NORTH;
            case "L" -> WEST;
            case "R" -> EAST;
            case "D" -> SOUTH;
            default -> throw new IllegalArgumentException("input not recognized");
        };
    }

    public static Direction fromInt(Integer input) {
        return switch (input) {
            case 0 -> EAST;
            case 1 -> SOUTH;
            case 2 -> WEST;
            case 3 -> NORTH;
            default -> throw new IllegalArgumentException("input not recognized");
        };
    }
}

