/*
 * Decompiled with CFR 0.152.
 */
package de.gitterrost4.adventofcode.base;

import de.gitterrost4.adventofcode.base.Direction3D;

public record Coordinate3D(int x, int y, int z) {
    public Coordinate3D getDirection(Direction3D direction) {
        return this.getDirection(direction, 1);
    }

    public Coordinate3D getDirection(Direction3D direction, int amount) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction3D.NORTH -> this.getNorth(amount);
            case Direction3D.SOUTH -> this.getSouth(amount);
            case Direction3D.EAST -> this.getEast(amount);
            case Direction3D.WEST -> this.getWest(amount);
            case Direction3D.UP -> this.getUp(amount);
            case Direction3D.DOWN -> this.getDown(amount);
        };
    }

    public Coordinate3D getEast() {
        return this.getEast(1);
    }

    public Coordinate3D getEast(int amount) {
        return new Coordinate3D(this.x, this.y + amount, this.z);
    }

    public Coordinate3D getWest() {
        return this.getWest(1);
    }

    public Coordinate3D getWest(int amount) {
        return new Coordinate3D(this.x, this.y - amount, this.z);
    }

    public Coordinate3D getNorth() {
        return this.getNorth(1);
    }

    public Coordinate3D getNorth(int amount) {
        return new Coordinate3D(this.x - amount, this.y, this.z);
    }

    public Coordinate3D getSouth() {
        return this.getSouth(1);
    }

    public Coordinate3D getSouth(int amount) {
        return new Coordinate3D(this.x + amount, this.y, this.z);
    }

    public Coordinate3D getUp() {
        return this.getUp(1);
    }

    public Coordinate3D getUp(int amount) {
        return new Coordinate3D(this.x, this.y, this.z + amount);
    }

    public Coordinate3D getDown() {
        return this.getDown(1);
    }

    public Coordinate3D getDown(int amount) {
        return new Coordinate3D(this.x, this.y, this.z - amount);
    }

    public long distance1From(Coordinate3D other) {
        return Math.abs(this.x - other.x) + Math.abs(this.y - other.y) + Math.abs(this.z - other.z);
    }

    public boolean isBetween(Coordinate3D oneCornerInclusive, Coordinate3D otherCornerInclusive) {
        return (this.x <= oneCornerInclusive.x && this.x >= otherCornerInclusive.x || this.x >= oneCornerInclusive.x && this.x <= otherCornerInclusive.x) && (this.y <= oneCornerInclusive.y && this.y >= otherCornerInclusive.y || this.y >= oneCornerInclusive.y && this.y <= otherCornerInclusive.y) && (this.z <= oneCornerInclusive.z && this.z >= otherCornerInclusive.z || this.z >= oneCornerInclusive.z && this.z <= otherCornerInclusive.z);
    }

    @Override
    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }
}

