/*
 * Decompiled with CFR 0.152.
 */
package de.gitterrost4.adventofcode.base;

public enum Direction {
    NORTH,
    SOUTH,
    EAST,
    WEST,
    NORTHEAST,
    SOUTHEAST,
    NORTHWEST,
    SOUTHWEST;


    public Direction opposite() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> SOUTH;
            case 1 -> NORTH;
            case 2 -> WEST;
            case 3 -> EAST;
            case 4 -> SOUTHWEST;
            case 6 -> SOUTHEAST;
            case 5 -> NORTHWEST;
            case 7 -> NORTHEAST;
        };
    }

    public Direction clockwiseNext8() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> EAST;
            case 1 -> WEST;
            case 2 -> SOUTH;
            case 3 -> NORTH;
            case 4 -> SOUTHEAST;
            case 6 -> NORTHEAST;
            case 5 -> SOUTHWEST;
            case 7 -> NORTHWEST;
        };
    }

    public Direction counterClockwiseNext8() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> WEST;
            case 3 -> SOUTH;
            case 1 -> EAST;
            case 2 -> NORTH;
            case 4 -> NORTHWEST;
            case 6 -> SOUTHWEST;
            case 7 -> SOUTHEAST;
            case 5 -> NORTHEAST;
        };
    }

    public Direction clockwiseNext() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> NORTHEAST;
            case 4 -> EAST;
            case 2 -> SOUTHEAST;
            case 5 -> SOUTH;
            case 1 -> SOUTHWEST;
            case 7 -> WEST;
            case 3 -> NORTHWEST;
            case 6 -> NORTH;
        };
    }

    public Direction counterClockwiseNext() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> NORTHWEST;
            case 6 -> WEST;
            case 3 -> SOUTHWEST;
            case 7 -> SOUTH;
            case 1 -> SOUTHEAST;
            case 5 -> EAST;
            case 2 -> NORTHEAST;
            case 4 -> NORTH;
        };
    }

    public static Direction fromLaymanTerms(String input) {
        return switch (input) {
            case "U" -> NORTH;
            case "L" -> WEST;
            case "R" -> EAST;
            case "D" -> SOUTH;
            default -> throw new IllegalArgumentException("input not recognized");
        };
    }

    public static Direction fromInt(Integer input) {
        return switch (input) {
            case 0 -> EAST;
            case 1 -> SOUTH;
            case 2 -> WEST;
            case 3 -> NORTH;
            default -> throw new IllegalArgumentException("input not recognized");
        };
    }

    public static Direction[] values4() {
        return new Direction[]{NORTH, SOUTH, EAST, WEST};
    }
}

