/*
 * Decompiled with CFR 0.152.
 */
package de.gitterrost4.adventofcode.base;

import de.gitterrost4.adventofcode.base.Coordinate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Grid {
    protected final List<List<String>> grid;

    public Grid(List<String> lines) {
        this.grid = lines.stream().map(s -> Arrays.stream(s.split("")).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public Grid(String lines) {
        this.grid = Arrays.stream(lines.split("\n")).map(s -> Arrays.stream(s.split("")).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public String get(Coordinate coordinate) {
        return this.grid.get(coordinate.x()).get(coordinate.y());
    }

    public int width() {
        return this.grid.get(0).size();
    }

    public int height() {
        return this.grid.size();
    }

    public boolean isValidCoordinate(Coordinate coordinate) {
        return coordinate.isBetween(new Coordinate(0, 0), new Coordinate(this.height() - 1, this.width() - 1));
    }

    public Stream<Coordinate> allCoordinates() {
        return IntStream.range(0, this.height()).boxed().flatMap(i -> IntStream.range(0, this.width()).mapToObj(j -> new Coordinate((int)i, j)));
    }

    public String toString() {
        return this.grid.stream().map(sl -> sl.stream().collect(Collectors.joining())).collect(Collectors.joining("\n"));
    }
}

