/*
 * Decompiled with CFR 0.152.
 */
package de.gitterrost4.adventofcode.base;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Optional;

public abstract class Puzzle {
    protected final String resourceDir;
    protected final int year;
    protected final int day;

    public Puzzle(int year, int day) {
        this.year = year;
        this.day = day;
        this.resourceDir = "y" + year + "/day" + day;
    }

    public abstract Object partOne();

    public abstract Object partTwo();

    protected List<String> input() {
        return Puzzle.getResourceLines(this.resourceDir + "/input.txt");
    }

    protected String asRaw(List<String> input) {
        return String.join((CharSequence)"\n", input);
    }

    protected List<List<String>> asSingle(List<String> input) {
        return input.stream().map(x -> Arrays.stream(x.split("")).toList()).toList();
    }

    protected List<String> sampleInput1() {
        return Puzzle.getResourceLines(this.resourceDir + "/sampleInput1.txt");
    }

    protected List<String> sampleInput2() {
        return Puzzle.getResourceLines(this.resourceDir + "/sampleInput2.txt");
    }

    public void printSolutions() {
        Instant now = Instant.now();
        Object part1 = this.partOne();
        long part1Time = Duration.between(now, Instant.now()).toMillis();
        if (part1 != null) {
            System.out.printf("%4d/%02d   Part 1: %-20s %dms\n", this.year, this.day, part1, part1Time);
            now = Instant.now();
            Object part2 = this.partTwo();
            long part2Time = Duration.between(now, Instant.now()).toMillis();
            if (part2 != null) {
                System.out.printf("          Part 2: %-20s %dms\n", part2, part2Time);
            }
        }
    }

    public static List<String> getResourceLines(String path) {
        List<String> list;
        block8: {
            InputStream is = Puzzle.getResourceAsInputStream(path);
            try {
                list = Optional.ofNullable(is).map(InputStreamReader::new).map(BufferedReader::new).map(BufferedReader::lines).orElseThrow(() -> new MissingResourceException("Resource " + path + " not found.", Puzzle.class.getName(), path)).toList();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not open file " + path);
                }
            }
            is.close();
        }
        return list;
    }

    public static InputStream getResourceAsInputStream(String path) {
        return Puzzle.class.getClassLoader().getResourceAsStream(path);
    }
}

